﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    public class _Info : ContextBase {
        public _Info(Context context) : base(context) {
        }

        int iloscKopii = 1;
        [Caption("Ilość kopii")]
        public int IloscKopii {
            get { return iloscKopii; }
            set {
                if (value <= 0)
                    value = 1;
                iloscKopii = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    _Info info;
    [Context]
    public _Info Info {
        set { info = value; }
    }
    
    protected void dc_ContextLoad(object sender, EventArgs e) {
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
        ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc(ph);        
        
        KadryModule module = KadryModule.GetInstance(dc);
        sadpracy.EditValue = module.Config.Wydruki.SądPracy.Length > 0 ?
            module.Config.Wydruki.SądPracy : "Sądu Rejonowego - Sądu Pracy w ...................................................................................................................................................";
        
        if (ph.Etat.OkresWypowiedzenia.Uplywa != Date.Empty)
            colUplywa.EditValue = ph.Etat.OkresWypowiedzenia.Uplywa;
        else if (ph.Etat.Okres.To != Date.Empty && ph.Etat.Okres.To != Date.MaxValue)
            colUplywa.EditValue = ph.Etat.Okres.To;
        else {
            colUplywa.EditValue = "....................";
            colUplywa.Bold = false;
        }

        if (ph.Etat.OkresWypowiedzenia.Dni > 0)
            switch (ph.Etat.OkresWypowiedzenia.Dni) {
                case 1:
                    colOkresWypowiedzenia.EditValue = "jednodniowego"; break;
                case 2:
                    colOkresWypowiedzenia.EditValue = "dwudniowego"; break;
                case 3:
                    colOkresWypowiedzenia.EditValue = "trzydniowego"; break;
                case 4:
                    colOkresWypowiedzenia.EditValue = "czterodniowego"; break;
                case 5:
                    colOkresWypowiedzenia.EditValue = "pięciodniowego"; break;
                case 6:
                    colOkresWypowiedzenia.EditValue = "sześciodniowego"; break;
                default:
                    colOkresWypowiedzenia.EditValue = ph.Etat.OkresWypowiedzenia.Dni + "-dniowego"; break;
            }
        else if (ph.Etat.OkresWypowiedzenia.Miesiace > 0)
            switch (ph.Etat.OkresWypowiedzenia.Miesiace) {
                case 1:
                    colOkresWypowiedzenia.EditValue = "jednomiesięcznego"; break;
                case 2:
                    colOkresWypowiedzenia.EditValue = "dwumiesięcznego"; break;
                case 3:
                    colOkresWypowiedzenia.EditValue = "trzymiesięcznego"; break;
                case 4:
                    colOkresWypowiedzenia.EditValue = "czteromiesięcznego"; break;
                case 5:
                    colOkresWypowiedzenia.EditValue = "pięciomiesięcznego"; break;
                case 6:
                    colOkresWypowiedzenia.EditValue = "sześciomiesięcznego"; break;
                default:
                    colOkresWypowiedzenia.EditValue = ph.Etat.OkresWypowiedzenia.Miesiace + "-miesięcznego"; break;
            }
        else if (ph.Etat.OkresWypowiedzenia.Tygodnie > 0)
            switch (ph.Etat.OkresWypowiedzenia.Tygodnie) {
                case 1:
                    colOkresWypowiedzenia.EditValue = "jednotygodniowego"; break;
                case 2:
                    colOkresWypowiedzenia.EditValue = "dwutygodniowego"; break;
                case 3:
                    colOkresWypowiedzenia.EditValue = "trzytygodniowego"; break;
                case 4:
                    colOkresWypowiedzenia.EditValue = "czterotygodniowego"; break;
                case 5:
                    colOkresWypowiedzenia.EditValue = "pięciotygodniowego"; break;
                case 6:
                    colOkresWypowiedzenia.EditValue = "sześciotygodniowego"; break;
                default:
                    colOkresWypowiedzenia.EditValue = ph.Etat.OkresWypowiedzenia.Tygodnie + "-tygodniowego"; break;
            }
        else {
            colOkresWypowiedzenia.EditValue = "....................";
            colOkresWypowiedzenia.Bold = false;
        }

        if (ph.Etat.PrzyczynaRozwUmowy != "")
            colPrzyczyna.EditValue = ph.Etat.PrzyczynaRozwUmowy + ".";
        else {
            colPrzyczyna.EditValue =
                ".....................................................................................................................................................................................................<br/>" +
                ".....................................................................................................................................................................................................<br/>" +
                ".....................................................................................................................................................................................................";
            colPrzyczyna.Bold = false;
        }

        ArrayList al = new ArrayList();
        for (int i = 0; i < info.IloscKopii; i++)
            al.Add(ph);
        DataRepeater1.DataSource = al;
    }

    string GetMiejscowosc(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
        if (miejscowosc.Length == 0)
            miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
        }                
        return miejscowosc;
    }
</script>

<html>
	<head>
		<title>Tytuł wydruku</title>		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR"/>
		<meta content="C#" name="CODE_LANGUAGE"/>
		<meta content="JavaScript" name="vs_defaultClientScript"/>
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema"/>
	</head>
	<body>
		<form id="form" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" OnContextLoad="dc_ContextLoad"></ea:datacontext>
            <ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" Width="100%" Height="161px">
            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
				ResetPageCounter="True"></ea:PageBreak>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="ROZWIĄZANIE UMOWY O PRACĘ ZA WYPOWIEDZENIEM *|<p align=right></strong>%MIEJSCOWOSC%, {0}<strong></p>" runat="server" DataMember0="Context.ActualDate.Actual"></cc1:ReportHeader>
			<font face="Tahoma" size="2">
			<p>
								<ea:DataLabel id="DataLabel1" runat="server" DataMember="Plec" Bold="False">
									<ValuesMap>
										<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
										<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
									</ValuesMap>
								</ea:DataLabel>
                <br />
							<ea:DataLabel id="DataLabel3" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:DataLabel>
			</p>
                <p>
                    Rozwiązuje z
					<ea:DataLabel id="DataLabel5" runat="server" DataMember="Plec" Bold="False">
						<ValuesMap>
							<ea:ValuesPair Key="Kobieta" Value="Panią"></ea:ValuesPair>
							<ea:ValuesPair Key="Mężczyzna" Value="Panem"></ea:ValuesPair>
						</ValuesMap>
					</ea:DataLabel>
					&nbsp;umowę o pracę zawartą w dniu 
				<ea:DataLabel id="DataLabel2" runat="server" DataMember="Etat.DataZawarcia"></ea:DataLabel>&nbsp;z 
					zachowaniem <ea:DataLabel id="colOkresWypowiedzenia" runat="server">
                    </ea:DataLabel>
                okresu wypowiedzenia, który 
					upłynie w dniu 
				<ea:DataLabel id="colUplywa" runat="server"></ea:DataLabel>.
                </p>
			<p>Przyczyną rozwiązania umowy o pracę jest <ea:DataLabel id="colPrzyczyna" runat="server">
            </ea:DataLabel>
			</p>
			<p>Jednocześnie informuję, że w terminie 21 dni od daty 
					doręczenia niniejszego pisma przysługuje
					<ea:DataLabel id="DataLabel6" runat="server" DataMember="Plec" Bold="False">
						<ValuesMap>
							<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
							<ea:ValuesPair Key="Mężczyzna" Value="Panu"></ea:ValuesPair>
						</ValuesMap>
					</ea:DataLabel>
					prawo wniesienia odwołania do
                    <ea:datalabel id="sadpracy" runat="server" Bold="false"></ea:datalabel>.                    
			</p>
			<p>Przed upływem tego terminu może
					<ea:DataLabel id="DataLabel7" runat="server" DataMember="Plec" Bold="False">
						<ValuesMap>
							<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
							<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
						</ValuesMap>
					</ea:DataLabel>
					złożyć wniosek o wszczęcie postępowania pojednawczego przed 
					Komisją Pojednawczą&nbsp;** 
					...................................................................................................................................................
			</p>
			<p> * - dotyczy umowy o pracę zawartej na czas nieokreślony<br>
					** - dotyczy pracodawcy u którego zostanie utworzona komisja pojednawcza
			</p>
			</font>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="potwierdzenie odbioru przez pracownika - data i podpis" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="podpis pracodawcy lub osoby reprezentującej pracodawcę albo osoby uprawnionej do składania oświadczeń w imieniu pracodawcy"
						Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		<ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
		</form>
	</body>
</html>

